-- -------------------------- пример 1 --------------------------
applyTwice :: (a -> a) -> a -> a
applyTwice f x = f (f x)

increaseByTwo x = x + 2
result = applyTwice increaseByTwo 15 

-- -------------------------- пример 2 --------------------------
expression :: (Int -> Int -> Int) -> Int -> Int -> Int
expression operation arg1 arg2 = operation arg1 arg2

add :: Int -> Int -> Int
add arg1 arg2 = arg1 + arg2

multiply :: Int -> Int -> Int
multiply arg1 arg2 = arg1 * arg2

-- -------------------------- пример 3 --------------------------
greeting :: String -> IO ()
greeting name = print $ "Hello, " ++ name ++ "!"

myGreeting = greeting

-- -------------------------- пример 5 --------------------------
concatStr :: String -> String -> String
concatStr right = \left -> left ++ right

-- result = concatStr "Right"

-- -------------------------- пример 6 --------------------------
action1 :: String -> Int -> String
action1 text num = text ++ show num

action2 :: Int -> String -> String
action2 num text = text ++ show num

isEqual1 = action1 "March" 2023 == 2023 `action2` "March"
isEqual2 = action1 "Rain" 2024 == 2023 `action2` "Sun"

main = do
    myGreeting "Misho" -- Изход: Hello, Misho!
    print $ expression add 15 7 -- Изход: 22
    print $ expression multiply 3 14 -- Изход: 42
    print $ concatStr "Right" "Left" -- Изход: LeftRight
    print isEqual1 -- Изход: True
    print isEqual2 -- Изход: False